package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableMember invokes the ledgerdb.EnableMember API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/enablemember.html
func (client *Client) EnableMember(request *EnableMemberRequest) (response *EnableMemberResponse, err error) {
	response = CreateEnableMemberResponse()
	err = client.DoAction(request, response)
	return
}

// EnableMemberWithChan invokes the ledgerdb.EnableMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/enablemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableMemberWithChan(request *EnableMemberRequest) (<-chan *EnableMemberResponse, <-chan error) {
	responseChan := make(chan *EnableMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableMemberWithCallback invokes the ledgerdb.EnableMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/enablemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableMemberWithCallback(request *EnableMemberRequest, callback func(response *EnableMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableMemberResponse
		var err error
		defer close(result)
		response, err = client.EnableMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableMemberRequest is the request struct for api EnableMember
type EnableMemberRequest struct {
	*requests.RpcRequest
	LedgerId string `position:"Body" name:"LedgerId"`
	MemberId string `position:"Body" name:"MemberId"`
}

// EnableMemberResponse is the response struct for api EnableMember
type EnableMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableMemberRequest creates a request to invoke EnableMember API
func CreateEnableMemberRequest() (request *EnableMemberRequest) {
	request = &EnableMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "EnableMember", "ledgerdb", "openAPI")
	return
}

// CreateEnableMemberResponse creates a response to parse from EnableMember response
func CreateEnableMemberResponse() (response *EnableMemberResponse) {
	response = &EnableMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
