package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEdgeInstanceChannel invokes the iot.UpdateEdgeInstanceChannel API synchronously
func (client *Client) UpdateEdgeInstanceChannel(request *UpdateEdgeInstanceChannelRequest) (response *UpdateEdgeInstanceChannelResponse, err error) {
	response = CreateUpdateEdgeInstanceChannelResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEdgeInstanceChannelWithChan invokes the iot.UpdateEdgeInstanceChannel API asynchronously
func (client *Client) UpdateEdgeInstanceChannelWithChan(request *UpdateEdgeInstanceChannelRequest) (<-chan *UpdateEdgeInstanceChannelResponse, <-chan error) {
	responseChan := make(chan *UpdateEdgeInstanceChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEdgeInstanceChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEdgeInstanceChannelWithCallback invokes the iot.UpdateEdgeInstanceChannel API asynchronously
func (client *Client) UpdateEdgeInstanceChannelWithCallback(request *UpdateEdgeInstanceChannelRequest, callback func(response *UpdateEdgeInstanceChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEdgeInstanceChannelResponse
		var err error
		defer close(result)
		response, err = client.UpdateEdgeInstanceChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEdgeInstanceChannelRequest is the request struct for api UpdateEdgeInstanceChannel
type UpdateEdgeInstanceChannelRequest struct {
	*requests.RpcRequest
	Configs       *[]UpdateEdgeInstanceChannelConfigs `position:"Query" name:"Configs"  type:"Repeated"`
	DriverId      string                              `position:"Query" name:"DriverId"`
	IotInstanceId string                              `position:"Query" name:"IotInstanceId"`
	ChannelName   string                              `position:"Query" name:"ChannelName"`
	InstanceId    string                              `position:"Query" name:"InstanceId"`
	ApiProduct    string                              `position:"Body" name:"ApiProduct"`
	ApiRevision   string                              `position:"Body" name:"ApiRevision"`
	ChannelId     string                              `position:"Query" name:"ChannelId"`
}

// UpdateEdgeInstanceChannelConfigs is a repeated param struct in UpdateEdgeInstanceChannelRequest
type UpdateEdgeInstanceChannelConfigs struct {
	Format  string `name:"Format"`
	Content string `name:"Content"`
	Key     string `name:"Key"`
}

// UpdateEdgeInstanceChannelResponse is the response struct for api UpdateEdgeInstanceChannel
type UpdateEdgeInstanceChannelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateEdgeInstanceChannelRequest creates a request to invoke UpdateEdgeInstanceChannel API
func CreateUpdateEdgeInstanceChannelRequest() (request *UpdateEdgeInstanceChannelRequest) {
	request = &UpdateEdgeInstanceChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateEdgeInstanceChannel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEdgeInstanceChannelResponse creates a response to parse from UpdateEdgeInstanceChannel response
func CreateUpdateEdgeInstanceChannelResponse() (response *UpdateEdgeInstanceChannelResponse) {
	response = &UpdateEdgeInstanceChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
