package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshDeviceTunnelSharePassword invokes the iot.RefreshDeviceTunnelSharePassword API synchronously
func (client *Client) RefreshDeviceTunnelSharePassword(request *RefreshDeviceTunnelSharePasswordRequest) (response *RefreshDeviceTunnelSharePasswordResponse, err error) {
	response = CreateRefreshDeviceTunnelSharePasswordResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshDeviceTunnelSharePasswordWithChan invokes the iot.RefreshDeviceTunnelSharePassword API asynchronously
func (client *Client) RefreshDeviceTunnelSharePasswordWithChan(request *RefreshDeviceTunnelSharePasswordRequest) (<-chan *RefreshDeviceTunnelSharePasswordResponse, <-chan error) {
	responseChan := make(chan *RefreshDeviceTunnelSharePasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshDeviceTunnelSharePassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshDeviceTunnelSharePasswordWithCallback invokes the iot.RefreshDeviceTunnelSharePassword API asynchronously
func (client *Client) RefreshDeviceTunnelSharePasswordWithCallback(request *RefreshDeviceTunnelSharePasswordRequest, callback func(response *RefreshDeviceTunnelSharePasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshDeviceTunnelSharePasswordResponse
		var err error
		defer close(result)
		response, err = client.RefreshDeviceTunnelSharePassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshDeviceTunnelSharePasswordRequest is the request struct for api RefreshDeviceTunnelSharePassword
type RefreshDeviceTunnelSharePasswordRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// RefreshDeviceTunnelSharePasswordResponse is the response struct for api RefreshDeviceTunnelSharePassword
type RefreshDeviceTunnelSharePasswordResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Password     string `json:"Password" xml:"Password"`
}

// CreateRefreshDeviceTunnelSharePasswordRequest creates a request to invoke RefreshDeviceTunnelSharePassword API
func CreateRefreshDeviceTunnelSharePasswordRequest() (request *RefreshDeviceTunnelSharePasswordRequest) {
	request = &RefreshDeviceTunnelSharePasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "RefreshDeviceTunnelSharePassword", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshDeviceTunnelSharePasswordResponse creates a response to parse from RefreshDeviceTunnelSharePassword response
func CreateRefreshDeviceTunnelSharePasswordResponse() (response *RefreshDeviceTunnelSharePasswordResponse) {
	response = &RefreshDeviceTunnelSharePasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
