package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindRoleToEdgeInstance invokes the iot.BindRoleToEdgeInstance API synchronously
func (client *Client) BindRoleToEdgeInstance(request *BindRoleToEdgeInstanceRequest) (response *BindRoleToEdgeInstanceResponse, err error) {
	response = CreateBindRoleToEdgeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// BindRoleToEdgeInstanceWithChan invokes the iot.BindRoleToEdgeInstance API asynchronously
func (client *Client) BindRoleToEdgeInstanceWithChan(request *BindRoleToEdgeInstanceRequest) (<-chan *BindRoleToEdgeInstanceResponse, <-chan error) {
	responseChan := make(chan *BindRoleToEdgeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindRoleToEdgeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindRoleToEdgeInstanceWithCallback invokes the iot.BindRoleToEdgeInstance API asynchronously
func (client *Client) BindRoleToEdgeInstanceWithCallback(request *BindRoleToEdgeInstanceRequest, callback func(response *BindRoleToEdgeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindRoleToEdgeInstanceResponse
		var err error
		defer close(result)
		response, err = client.BindRoleToEdgeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindRoleToEdgeInstanceRequest is the request struct for api BindRoleToEdgeInstance
type BindRoleToEdgeInstanceRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	RoleName      string `position:"Query" name:"RoleName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	RoleArn       string `position:"Query" name:"RoleArn"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// BindRoleToEdgeInstanceResponse is the response struct for api BindRoleToEdgeInstance
type BindRoleToEdgeInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBindRoleToEdgeInstanceRequest creates a request to invoke BindRoleToEdgeInstance API
func CreateBindRoleToEdgeInstanceRequest() (request *BindRoleToEdgeInstanceRequest) {
	request = &BindRoleToEdgeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BindRoleToEdgeInstance", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindRoleToEdgeInstanceResponse creates a response to parse from BindRoleToEdgeInstance response
func CreateBindRoleToEdgeInstanceResponse() (response *BindRoleToEdgeInstanceResponse) {
	response = &BindRoleToEdgeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
