package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteEdgeInstanceChannel invokes the iot.BatchDeleteEdgeInstanceChannel API synchronously
func (client *Client) BatchDeleteEdgeInstanceChannel(request *BatchDeleteEdgeInstanceChannelRequest) (response *BatchDeleteEdgeInstanceChannelResponse, err error) {
	response = CreateBatchDeleteEdgeInstanceChannelResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteEdgeInstanceChannelWithChan invokes the iot.BatchDeleteEdgeInstanceChannel API asynchronously
func (client *Client) BatchDeleteEdgeInstanceChannelWithChan(request *BatchDeleteEdgeInstanceChannelRequest) (<-chan *BatchDeleteEdgeInstanceChannelResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteEdgeInstanceChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteEdgeInstanceChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteEdgeInstanceChannelWithCallback invokes the iot.BatchDeleteEdgeInstanceChannel API asynchronously
func (client *Client) BatchDeleteEdgeInstanceChannelWithCallback(request *BatchDeleteEdgeInstanceChannelRequest, callback func(response *BatchDeleteEdgeInstanceChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteEdgeInstanceChannelResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteEdgeInstanceChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteEdgeInstanceChannelRequest is the request struct for api BatchDeleteEdgeInstanceChannel
type BatchDeleteEdgeInstanceChannelRequest struct {
	*requests.RpcRequest
	DriverId      string    `position:"Query" name:"DriverId"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	ChannelIds    *[]string `position:"Query" name:"ChannelIds"  type:"Repeated"`
}

// BatchDeleteEdgeInstanceChannelResponse is the response struct for api BatchDeleteEdgeInstanceChannel
type BatchDeleteEdgeInstanceChannelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBatchDeleteEdgeInstanceChannelRequest creates a request to invoke BatchDeleteEdgeInstanceChannel API
func CreateBatchDeleteEdgeInstanceChannelRequest() (request *BatchDeleteEdgeInstanceChannelRequest) {
	request = &BatchDeleteEdgeInstanceChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchDeleteEdgeInstanceChannel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteEdgeInstanceChannelResponse creates a response to parse from BatchDeleteEdgeInstanceChannel response
func CreateBatchDeleteEdgeInstanceChannelResponse() (response *BatchDeleteEdgeInstanceChannelResponse) {
	response = &BatchDeleteEdgeInstanceChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
