package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectLiverSteatosis invokes the imageprocess.DetectLiverSteatosis API synchronously
func (client *Client) DetectLiverSteatosis(request *DetectLiverSteatosisRequest) (response *DetectLiverSteatosisResponse, err error) {
	response = CreateDetectLiverSteatosisResponse()
	err = client.DoAction(request, response)
	return
}

// DetectLiverSteatosisWithChan invokes the imageprocess.DetectLiverSteatosis API asynchronously
func (client *Client) DetectLiverSteatosisWithChan(request *DetectLiverSteatosisRequest) (<-chan *DetectLiverSteatosisResponse, <-chan error) {
	responseChan := make(chan *DetectLiverSteatosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectLiverSteatosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectLiverSteatosisWithCallback invokes the imageprocess.DetectLiverSteatosis API asynchronously
func (client *Client) DetectLiverSteatosisWithCallback(request *DetectLiverSteatosisRequest, callback func(response *DetectLiverSteatosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectLiverSteatosisResponse
		var err error
		defer close(result)
		response, err = client.DetectLiverSteatosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectLiverSteatosisRequest is the request struct for api DetectLiverSteatosis
type DetectLiverSteatosisRequest struct {
	*requests.RpcRequest
	OrgName    string                         `position:"Body" name:"OrgName"`
	SourceType string                         `position:"Body" name:"SourceType"`
	DataFormat string                         `position:"Body" name:"DataFormat"`
	URLList    *[]DetectLiverSteatosisURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string                         `position:"Body" name:"OrgId"`
	Async      requests.Boolean               `position:"Body" name:"Async"`
}

// DetectLiverSteatosisURLList is a repeated param struct in DetectLiverSteatosisRequest
type DetectLiverSteatosisURLList struct {
	URL string `name:"URL"`
}

// DetectLiverSteatosisResponse is the response struct for api DetectLiverSteatosis
type DetectLiverSteatosisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectLiverSteatosisRequest creates a request to invoke DetectLiverSteatosis API
func CreateDetectLiverSteatosisRequest() (request *DetectLiverSteatosisRequest) {
	request = &DetectLiverSteatosisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectLiverSteatosis", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectLiverSteatosisResponse creates a response to parse from DetectLiverSteatosis response
func CreateDetectLiverSteatosisResponse() (response *DetectLiverSteatosisResponse) {
	response = &DetectLiverSteatosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
