package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeregisterAuthenticator invokes the idaas_doraemon.DeregisterAuthenticator API synchronously
func (client *Client) DeregisterAuthenticator(request *DeregisterAuthenticatorRequest) (response *DeregisterAuthenticatorResponse, err error) {
	response = CreateDeregisterAuthenticatorResponse()
	err = client.DoAction(request, response)
	return
}

// DeregisterAuthenticatorWithChan invokes the idaas_doraemon.DeregisterAuthenticator API asynchronously
func (client *Client) DeregisterAuthenticatorWithChan(request *DeregisterAuthenticatorRequest) (<-chan *DeregisterAuthenticatorResponse, <-chan error) {
	responseChan := make(chan *DeregisterAuthenticatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeregisterAuthenticator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeregisterAuthenticatorWithCallback invokes the idaas_doraemon.DeregisterAuthenticator API asynchronously
func (client *Client) DeregisterAuthenticatorWithCallback(request *DeregisterAuthenticatorRequest, callback func(response *DeregisterAuthenticatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeregisterAuthenticatorResponse
		var err error
		defer close(result)
		response, err = client.DeregisterAuthenticator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeregisterAuthenticatorRequest is the request struct for api DeregisterAuthenticator
type DeregisterAuthenticatorRequest struct {
	*requests.RpcRequest
	UserId                string `position:"Query" name:"UserId"`
	AuthenticatorUuid     string `position:"Query" name:"AuthenticatorUuid"`
	ApplicationExternalId string `position:"Query" name:"ApplicationExternalId"`
}

// DeregisterAuthenticatorResponse is the response struct for api DeregisterAuthenticator
type DeregisterAuthenticatorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeregisterAuthenticatorRequest creates a request to invoke DeregisterAuthenticator API
func CreateDeregisterAuthenticatorRequest() (request *DeregisterAuthenticatorRequest) {
	request = &DeregisterAuthenticatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "DeregisterAuthenticator", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeregisterAuthenticatorResponse creates a response to parse from DeregisterAuthenticator response
func CreateDeregisterAuthenticatorResponse() (response *DeregisterAuthenticatorResponse) {
	response = &DeregisterAuthenticatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
