package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLLogsV2 invokes the gpdb.DescribeSQLLogsV2 API synchronously
func (client *Client) DescribeSQLLogsV2(request *DescribeSQLLogsV2Request) (response *DescribeSQLLogsV2Response, err error) {
	response = CreateDescribeSQLLogsV2Response()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLLogsV2WithChan invokes the gpdb.DescribeSQLLogsV2 API asynchronously
func (client *Client) DescribeSQLLogsV2WithChan(request *DescribeSQLLogsV2Request) (<-chan *DescribeSQLLogsV2Response, <-chan error) {
	responseChan := make(chan *DescribeSQLLogsV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLLogsV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLLogsV2WithCallback invokes the gpdb.DescribeSQLLogsV2 API asynchronously
func (client *Client) DescribeSQLLogsV2WithCallback(request *DescribeSQLLogsV2Request, callback func(response *DescribeSQLLogsV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLLogsV2Response
		var err error
		defer close(result)
		response, err = client.DescribeSQLLogsV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLLogsV2Request is the request struct for api DescribeSQLLogsV2
type DescribeSQLLogsV2Request struct {
	*requests.RpcRequest
	StartTime       string `position:"Query" name:"StartTime"`
	QueryKeywords   string `position:"Query" name:"QueryKeywords"`
	PageNumber      string `position:"Query" name:"PageNumber"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	Database        string `position:"Query" name:"Database"`
	SourceIP        string `position:"Query" name:"SourceIP"`
	MinExecuteCost  string `position:"Query" name:"MinExecuteCost"`
	PageSize        string `position:"Query" name:"PageSize"`
	DBInstanceId    string `position:"Query" name:"DBInstanceId"`
	MaxExecuteCost  string `position:"Query" name:"MaxExecuteCost"`
	ExecuteCost     string `position:"Query" name:"ExecuteCost"`
	ExecuteState    string `position:"Query" name:"ExecuteState"`
	EndTime         string `position:"Query" name:"EndTime"`
	OperationType   string `position:"Query" name:"OperationType"`
	OperationClass  string `position:"Query" name:"OperationClass"`
	User            string `position:"Query" name:"User"`
}

// DescribeSQLLogsV2Response is the response struct for api DescribeSQLLogsV2
type DescribeSQLLogsV2Response struct {
	*responses.BaseResponse
	PageRecordCount int    `json:"PageRecordCount" xml:"PageRecordCount"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	PageNumber      int    `json:"PageNumber" xml:"PageNumber"`
	Items           []Item `json:"Items" xml:"Items"`
}

// CreateDescribeSQLLogsV2Request creates a request to invoke DescribeSQLLogsV2 API
func CreateDescribeSQLLogsV2Request() (request *DescribeSQLLogsV2Request) {
	request = &DescribeSQLLogsV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeSQLLogsV2", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLLogsV2Response creates a response to parse from DescribeSQLLogsV2 response
func CreateDescribeSQLLogsV2Response() (response *DescribeSQLLogsV2Response) {
	response = &DescribeSQLLogsV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
