package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCollection invokes the gpdb.DescribeCollection API synchronously
func (client *Client) DescribeCollection(request *DescribeCollectionRequest) (response *DescribeCollectionResponse, err error) {
	response = CreateDescribeCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCollectionWithChan invokes the gpdb.DescribeCollection API asynchronously
func (client *Client) DescribeCollectionWithChan(request *DescribeCollectionRequest) (<-chan *DescribeCollectionResponse, <-chan error) {
	responseChan := make(chan *DescribeCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCollectionWithCallback invokes the gpdb.DescribeCollection API asynchronously
func (client *Client) DescribeCollectionWithCallback(request *DescribeCollectionRequest, callback func(response *DescribeCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCollectionResponse
		var err error
		defer close(result)
		response, err = client.DescribeCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCollectionRequest is the request struct for api DescribeCollection
type DescribeCollectionRequest struct {
	*requests.RpcRequest
	DBInstanceId      string           `position:"Query" name:"DBInstanceId"`
	Collection        string           `position:"Query" name:"Collection"`
	OwnerId           requests.Integer `position:"Query" name:"OwnerId"`
	NamespacePassword string           `position:"Query" name:"NamespacePassword"`
	Namespace         string           `position:"Query" name:"Namespace"`
}

// DescribeCollectionResponse is the response struct for api DescribeCollection
type DescribeCollectionResponse struct {
	*responses.BaseResponse
	RequestId               string                 `json:"RequestId" xml:"RequestId"`
	Dimension               int                    `json:"Dimension" xml:"Dimension"`
	FullTextRetrievalFields string                 `json:"FullTextRetrievalFields" xml:"FullTextRetrievalFields"`
	Metadata                map[string]interface{} `json:"Metadata" xml:"Metadata"`
	Metrics                 string                 `json:"Metrics" xml:"Metrics"`
	Parser                  string                 `json:"Parser" xml:"Parser"`
	DBInstanceId            string                 `json:"DBInstanceId" xml:"DBInstanceId"`
	RegionId                string                 `json:"RegionId" xml:"RegionId"`
	Namespace               string                 `json:"Namespace" xml:"Namespace"`
	Message                 string                 `json:"Message" xml:"Message"`
	Status                  string                 `json:"Status" xml:"Status"`
}

// CreateDescribeCollectionRequest creates a request to invoke DescribeCollection API
func CreateDescribeCollectionRequest() (request *DescribeCollectionRequest) {
	request = &DescribeCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeCollection", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCollectionResponse creates a response to parse from DescribeCollection response
func CreateDescribeCollectionResponse() (response *DescribeCollectionResponse) {
	response = &DescribeCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
