package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBInstancePlan invokes the gpdb.DeleteDBInstancePlan API synchronously
func (client *Client) DeleteDBInstancePlan(request *DeleteDBInstancePlanRequest) (response *DeleteDBInstancePlanResponse, err error) {
	response = CreateDeleteDBInstancePlanResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBInstancePlanWithChan invokes the gpdb.DeleteDBInstancePlan API asynchronously
func (client *Client) DeleteDBInstancePlanWithChan(request *DeleteDBInstancePlanRequest) (<-chan *DeleteDBInstancePlanResponse, <-chan error) {
	responseChan := make(chan *DeleteDBInstancePlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBInstancePlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBInstancePlanWithCallback invokes the gpdb.DeleteDBInstancePlan API asynchronously
func (client *Client) DeleteDBInstancePlanWithCallback(request *DeleteDBInstancePlanRequest, callback func(response *DeleteDBInstancePlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBInstancePlanResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBInstancePlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBInstancePlanRequest is the request struct for api DeleteDBInstancePlan
type DeleteDBInstancePlanRequest struct {
	*requests.RpcRequest
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	PlanId       string           `position:"Query" name:"PlanId"`
}

// DeleteDBInstancePlanResponse is the response struct for api DeleteDBInstancePlan
type DeleteDBInstancePlanResponse struct {
	*responses.BaseResponse
	Status       string `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	PlanId       string `json:"PlanId" xml:"PlanId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
}

// CreateDeleteDBInstancePlanRequest creates a request to invoke DeleteDBInstancePlan API
func CreateDeleteDBInstancePlanRequest() (request *DeleteDBInstancePlanRequest) {
	request = &DeleteDBInstancePlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DeleteDBInstancePlan", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDBInstancePlanResponse creates a response to parse from DeleteDBInstancePlan response
func CreateDeleteDBInstancePlanResponse() (response *DeleteDBInstancePlanResponse) {
	response = &DeleteDBInstancePlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
