package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAccountFactoryBaselines invokes the governance.ListAccountFactoryBaselines API synchronously
func (client *Client) ListAccountFactoryBaselines(request *ListAccountFactoryBaselinesRequest) (response *ListAccountFactoryBaselinesResponse, err error) {
	response = CreateListAccountFactoryBaselinesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAccountFactoryBaselinesWithChan invokes the governance.ListAccountFactoryBaselines API asynchronously
func (client *Client) ListAccountFactoryBaselinesWithChan(request *ListAccountFactoryBaselinesRequest) (<-chan *ListAccountFactoryBaselinesResponse, <-chan error) {
	responseChan := make(chan *ListAccountFactoryBaselinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAccountFactoryBaselines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAccountFactoryBaselinesWithCallback invokes the governance.ListAccountFactoryBaselines API asynchronously
func (client *Client) ListAccountFactoryBaselinesWithCallback(request *ListAccountFactoryBaselinesRequest, callback func(response *ListAccountFactoryBaselinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAccountFactoryBaselinesResponse
		var err error
		defer close(result)
		response, err = client.ListAccountFactoryBaselines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAccountFactoryBaselinesRequest is the request struct for api ListAccountFactoryBaselines
type ListAccountFactoryBaselinesRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAccountFactoryBaselinesResponse is the response struct for api ListAccountFactoryBaselines
type ListAccountFactoryBaselinesResponse struct {
	*responses.BaseResponse
	NextToken string     `json:"NextToken" xml:"NextToken"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Baselines []Baseline `json:"Baselines" xml:"Baselines"`
}

// CreateListAccountFactoryBaselinesRequest creates a request to invoke ListAccountFactoryBaselines API
func CreateListAccountFactoryBaselinesRequest() (request *ListAccountFactoryBaselinesRequest) {
	request = &ListAccountFactoryBaselinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "ListAccountFactoryBaselines", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAccountFactoryBaselinesResponse creates a response to parse from ListAccountFactoryBaselines response
func CreateListAccountFactoryBaselinesResponse() (response *ListAccountFactoryBaselinesResponse) {
	response = &ListAccountFactoryBaselinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
