package fnf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSchedule invokes the fnf.CreateSchedule API synchronously
func (client *Client) CreateSchedule(request *CreateScheduleRequest) (response *CreateScheduleResponse, err error) {
	response = CreateCreateScheduleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScheduleWithChan invokes the fnf.CreateSchedule API asynchronously
func (client *Client) CreateScheduleWithChan(request *CreateScheduleRequest) (<-chan *CreateScheduleResponse, <-chan error) {
	responseChan := make(chan *CreateScheduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSchedule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScheduleWithCallback invokes the fnf.CreateSchedule API asynchronously
func (client *Client) CreateScheduleWithCallback(request *CreateScheduleRequest, callback func(response *CreateScheduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScheduleResponse
		var err error
		defer close(result)
		response, err = client.CreateSchedule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScheduleRequest is the request struct for api CreateSchedule
type CreateScheduleRequest struct {
	*requests.RpcRequest
	CronExpression   string           `position:"Body" name:"CronExpression"`
	Description      string           `position:"Body" name:"Description"`
	ScheduleName     string           `position:"Body" name:"ScheduleName"`
	SignatureVersion string           `position:"Query" name:"SignatureVersion"`
	Payload          string           `position:"Body" name:"Payload"`
	Enable           requests.Boolean `position:"Body" name:"Enable"`
	FlowName         string           `position:"Body" name:"FlowName"`
}

// CreateScheduleResponse is the response struct for api CreateSchedule
type CreateScheduleResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Description      string `json:"Description" xml:"Description"`
	ScheduleId       string `json:"ScheduleId" xml:"ScheduleId"`
	Payload          string `json:"Payload" xml:"Payload"`
	ScheduleName     string `json:"ScheduleName" xml:"ScheduleName"`
	CreatedTime      string `json:"CreatedTime" xml:"CreatedTime"`
	LastModifiedTime string `json:"LastModifiedTime" xml:"LastModifiedTime"`
	CronExpression   string `json:"CronExpression" xml:"CronExpression"`
	Enable           bool   `json:"Enable" xml:"Enable"`
}

// CreateCreateScheduleRequest creates a request to invoke CreateSchedule API
func CreateCreateScheduleRequest() (request *CreateScheduleRequest) {
	request = &CreateScheduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("fnf", "2019-03-15", "CreateSchedule", "fnf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateScheduleResponse creates a response to parse from CreateSchedule response
func CreateCreateScheduleResponse() (response *CreateScheduleResponse) {
	response = &CreateScheduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
