package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRealPersonVerificationResult invokes the facebody.GetRealPersonVerificationResult API synchronously
func (client *Client) GetRealPersonVerificationResult(request *GetRealPersonVerificationResultRequest) (response *GetRealPersonVerificationResultResponse, err error) {
	response = CreateGetRealPersonVerificationResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetRealPersonVerificationResultWithChan invokes the facebody.GetRealPersonVerificationResult API asynchronously
func (client *Client) GetRealPersonVerificationResultWithChan(request *GetRealPersonVerificationResultRequest) (<-chan *GetRealPersonVerificationResultResponse, <-chan error) {
	responseChan := make(chan *GetRealPersonVerificationResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRealPersonVerificationResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRealPersonVerificationResultWithCallback invokes the facebody.GetRealPersonVerificationResult API asynchronously
func (client *Client) GetRealPersonVerificationResultWithCallback(request *GetRealPersonVerificationResultRequest, callback func(response *GetRealPersonVerificationResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRealPersonVerificationResultResponse
		var err error
		defer close(result)
		response, err = client.GetRealPersonVerificationResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRealPersonVerificationResultRequest is the request struct for api GetRealPersonVerificationResult
type GetRealPersonVerificationResultRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	MaterialHash       string           `position:"Body" name:"MaterialHash"`
	OssFile            string           `position:"Query" name:"OssFile"`
	VerificationToken  string           `position:"Body" name:"VerificationToken"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
}

// GetRealPersonVerificationResultResponse is the response struct for api GetRealPersonVerificationResult
type GetRealPersonVerificationResultResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetRealPersonVerificationResultRequest creates a request to invoke GetRealPersonVerificationResult API
func CreateGetRealPersonVerificationResultRequest() (request *GetRealPersonVerificationResultRequest) {
	request = &GetRealPersonVerificationResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "GetRealPersonVerificationResult", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRealPersonVerificationResultResponse creates a response to parse from GetRealPersonVerificationResult response
func CreateGetRealPersonVerificationResultResponse() (response *GetRealPersonVerificationResultResponse) {
	response = &GetRealPersonVerificationResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
