package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseEventStreaming invokes the eventbridge.PauseEventStreaming API synchronously
func (client *Client) PauseEventStreaming(request *PauseEventStreamingRequest) (response *PauseEventStreamingResponse, err error) {
	response = CreatePauseEventStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// PauseEventStreamingWithChan invokes the eventbridge.PauseEventStreaming API asynchronously
func (client *Client) PauseEventStreamingWithChan(request *PauseEventStreamingRequest) (<-chan *PauseEventStreamingResponse, <-chan error) {
	responseChan := make(chan *PauseEventStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseEventStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseEventStreamingWithCallback invokes the eventbridge.PauseEventStreaming API asynchronously
func (client *Client) PauseEventStreamingWithCallback(request *PauseEventStreamingRequest, callback func(response *PauseEventStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseEventStreamingResponse
		var err error
		defer close(result)
		response, err = client.PauseEventStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseEventStreamingRequest is the request struct for api PauseEventStreaming
type PauseEventStreamingRequest struct {
	*requests.RpcRequest
	EventStreamingName string `position:"Body" name:"EventStreamingName"`
}

// PauseEventStreamingResponse is the response struct for api PauseEventStreaming
type PauseEventStreamingResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePauseEventStreamingRequest creates a request to invoke PauseEventStreaming API
func CreatePauseEventStreamingRequest() (request *PauseEventStreamingRequest) {
	request = &PauseEventStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "PauseEventStreaming", "", "")
	request.Method = requests.POST
	return
}

// CreatePauseEventStreamingResponse creates a response to parse from PauseEventStreaming response
func CreatePauseEventStreamingResponse() (response *PauseEventStreamingResponse) {
	response = &PauseEventStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
