package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOssUsageData invokes the ens.GetOssUsageData API synchronously
func (client *Client) GetOssUsageData(request *GetOssUsageDataRequest) (response *GetOssUsageDataResponse, err error) {
	response = CreateGetOssUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetOssUsageDataWithChan invokes the ens.GetOssUsageData API asynchronously
func (client *Client) GetOssUsageDataWithChan(request *GetOssUsageDataRequest) (<-chan *GetOssUsageDataResponse, <-chan error) {
	responseChan := make(chan *GetOssUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOssUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOssUsageDataWithCallback invokes the ens.GetOssUsageData API asynchronously
func (client *Client) GetOssUsageDataWithCallback(request *GetOssUsageDataRequest, callback func(response *GetOssUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOssUsageDataResponse
		var err error
		defer close(result)
		response, err = client.GetOssUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOssUsageDataRequest is the request struct for api GetOssUsageData
type GetOssUsageDataRequest struct {
	*requests.RpcRequest
	StartTime string `position:"Query" name:"StartTime"`
	Period    string `position:"Query" name:"Period"`
	EndTime   string `position:"Query" name:"EndTime"`
	Bucket    string `position:"Query" name:"Bucket"`
}

// GetOssUsageDataResponse is the response struct for api GetOssUsageData
type GetOssUsageDataResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	UsageList []UsageListItem `json:"UsageList" xml:"UsageList"`
}

// CreateGetOssUsageDataRequest creates a request to invoke GetOssUsageData API
func CreateGetOssUsageDataRequest() (request *GetOssUsageDataRequest) {
	request = &GetOssUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "GetOssUsageData", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetOssUsageDataResponse creates a response to parse from GetOssUsageData response
func CreateGetOssUsageDataResponse() (response *GetOssUsageDataResponse) {
	response = &GetOssUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
