package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSDG invokes the ens.DeleteSDG API synchronously
func (client *Client) DeleteSDG(request *DeleteSDGRequest) (response *DeleteSDGResponse, err error) {
	response = CreateDeleteSDGResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSDGWithChan invokes the ens.DeleteSDG API asynchronously
func (client *Client) DeleteSDGWithChan(request *DeleteSDGRequest) (<-chan *DeleteSDGResponse, <-chan error) {
	responseChan := make(chan *DeleteSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSDGWithCallback invokes the ens.DeleteSDG API asynchronously
func (client *Client) DeleteSDGWithCallback(request *DeleteSDGRequest, callback func(response *DeleteSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSDGResponse
		var err error
		defer close(result)
		response, err = client.DeleteSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSDGRequest is the request struct for api DeleteSDG
type DeleteSDGRequest struct {
	*requests.RpcRequest
	SDGId *[]string `position:"Query" name:"SDGId"  type:"Json"`
}

// DeleteSDGResponse is the response struct for api DeleteSDG
type DeleteSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteSDGRequest creates a request to invoke DeleteSDG API
func CreateDeleteSDGRequest() (request *DeleteSDGRequest) {
	request = &DeleteSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSDGResponse creates a response to parse from DeleteSDG response
func CreateDeleteSDGResponse() (response *DeleteSDGResponse) {
	response = &DeleteSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
