package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunPipelines invokes the elasticsearch.RunPipelines API synchronously
func (client *Client) RunPipelines(request *RunPipelinesRequest) (response *RunPipelinesResponse, err error) {
	response = CreateRunPipelinesResponse()
	err = client.DoAction(request, response)
	return
}

// RunPipelinesWithChan invokes the elasticsearch.RunPipelines API asynchronously
func (client *Client) RunPipelinesWithChan(request *RunPipelinesRequest) (<-chan *RunPipelinesResponse, <-chan error) {
	responseChan := make(chan *RunPipelinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunPipelines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunPipelinesWithCallback invokes the elasticsearch.RunPipelines API asynchronously
func (client *Client) RunPipelinesWithCallback(request *RunPipelinesRequest, callback func(response *RunPipelinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunPipelinesResponse
		var err error
		defer close(result)
		response, err = client.RunPipelines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunPipelinesRequest is the request struct for api RunPipelines
type RunPipelinesRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
}

// RunPipelinesResponse is the response struct for api RunPipelines
type RunPipelinesResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRunPipelinesRequest creates a request to invoke RunPipelines API
func CreateRunPipelinesRequest() (request *RunPipelinesRequest) {
	request = &RunPipelinesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "RunPipelines", "/openapi/logstashes/[InstanceId]/pipelines/action/run", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunPipelinesResponse creates a response to parse from RunPipelines response
func CreateRunPipelinesResponse() (response *RunPipelinesResponse) {
	response = &RunPipelinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
