package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteComponentIndex invokes the elasticsearch.DeleteComponentIndex API synchronously
func (client *Client) DeleteComponentIndex(request *DeleteComponentIndexRequest) (response *DeleteComponentIndexResponse, err error) {
	response = CreateDeleteComponentIndexResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteComponentIndexWithChan invokes the elasticsearch.DeleteComponentIndex API asynchronously
func (client *Client) DeleteComponentIndexWithChan(request *DeleteComponentIndexRequest) (<-chan *DeleteComponentIndexResponse, <-chan error) {
	responseChan := make(chan *DeleteComponentIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteComponentIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteComponentIndexWithCallback invokes the elasticsearch.DeleteComponentIndex API asynchronously
func (client *Client) DeleteComponentIndexWithCallback(request *DeleteComponentIndexRequest, callback func(response *DeleteComponentIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteComponentIndexResponse
		var err error
		defer close(result)
		response, err = client.DeleteComponentIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteComponentIndexRequest is the request struct for api DeleteComponentIndex
type DeleteComponentIndexRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"name"`
}

// DeleteComponentIndexResponse is the response struct for api DeleteComponentIndex
type DeleteComponentIndexResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateDeleteComponentIndexRequest creates a request to invoke DeleteComponentIndex API
func CreateDeleteComponentIndexRequest() (request *DeleteComponentIndexRequest) {
	request = &DeleteComponentIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DeleteComponentIndex", "/openapi/instances/[InstanceId]/component-index/[name]", "elasticsearch", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteComponentIndexResponse creates a response to parse from DeleteComponentIndex response
func CreateDeleteComponentIndexResponse() (response *DeleteComponentIndexResponse) {
	response = &DeleteComponentIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
