package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseManagedIndex invokes the elasticsearch.CloseManagedIndex API synchronously
func (client *Client) CloseManagedIndex(request *CloseManagedIndexRequest) (response *CloseManagedIndexResponse, err error) {
	response = CreateCloseManagedIndexResponse()
	err = client.DoAction(request, response)
	return
}

// CloseManagedIndexWithChan invokes the elasticsearch.CloseManagedIndex API asynchronously
func (client *Client) CloseManagedIndexWithChan(request *CloseManagedIndexRequest) (<-chan *CloseManagedIndexResponse, <-chan error) {
	responseChan := make(chan *CloseManagedIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseManagedIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseManagedIndexWithCallback invokes the elasticsearch.CloseManagedIndex API asynchronously
func (client *Client) CloseManagedIndexWithCallback(request *CloseManagedIndexRequest, callback func(response *CloseManagedIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseManagedIndexResponse
		var err error
		defer close(result)
		response, err = client.CloseManagedIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseManagedIndexRequest is the request struct for api CloseManagedIndex
type CloseManagedIndexRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Index       string `position:"Path" name:"Index"`
}

// CloseManagedIndexResponse is the response struct for api CloseManagedIndex
type CloseManagedIndexResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseManagedIndexRequest creates a request to invoke CloseManagedIndex API
func CreateCloseManagedIndexRequest() (request *CloseManagedIndexRequest) {
	request = &CloseManagedIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CloseManagedIndex", "/openapi/instances/[InstanceId]/indices/[Index]/close-managed", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseManagedIndexResponse creates a response to parse from CloseManagedIndex response
func CreateCloseManagedIndexResponse() (response *CloseManagedIndexResponse) {
	response = &CloseManagedIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
