package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelDeletion invokes the elasticsearch.CancelDeletion API synchronously
func (client *Client) CancelDeletion(request *CancelDeletionRequest) (response *CancelDeletionResponse, err error) {
	response = CreateCancelDeletionResponse()
	err = client.DoAction(request, response)
	return
}

// CancelDeletionWithChan invokes the elasticsearch.CancelDeletion API asynchronously
func (client *Client) CancelDeletionWithChan(request *CancelDeletionRequest) (<-chan *CancelDeletionResponse, <-chan error) {
	responseChan := make(chan *CancelDeletionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelDeletion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelDeletionWithCallback invokes the elasticsearch.CancelDeletion API asynchronously
func (client *Client) CancelDeletionWithCallback(request *CancelDeletionRequest, callback func(response *CancelDeletionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelDeletionResponse
		var err error
		defer close(result)
		response, err = client.CancelDeletion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelDeletionRequest is the request struct for api CancelDeletion
type CancelDeletionRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// CancelDeletionResponse is the response struct for api CancelDeletion
type CancelDeletionResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelDeletionRequest creates a request to invoke CancelDeletion API
func CreateCancelDeletionRequest() (request *CancelDeletionRequest) {
	request = &CancelDeletionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CancelDeletion", "/openapi/instances/[InstanceId]/actions/cancel-deletion", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelDeletionResponse creates a response to parse from CancelDeletion response
func CreateCancelDeletionResponse() (response *CancelDeletionResponse) {
	response = &CancelDeletionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
