package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVccGrantRule invokes the eflo.DeleteVccGrantRule API synchronously
func (client *Client) DeleteVccGrantRule(request *DeleteVccGrantRuleRequest) (response *DeleteVccGrantRuleResponse, err error) {
	response = CreateDeleteVccGrantRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVccGrantRuleWithChan invokes the eflo.DeleteVccGrantRule API asynchronously
func (client *Client) DeleteVccGrantRuleWithChan(request *DeleteVccGrantRuleRequest) (<-chan *DeleteVccGrantRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteVccGrantRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVccGrantRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVccGrantRuleWithCallback invokes the eflo.DeleteVccGrantRule API asynchronously
func (client *Client) DeleteVccGrantRuleWithCallback(request *DeleteVccGrantRuleRequest, callback func(response *DeleteVccGrantRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVccGrantRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteVccGrantRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVccGrantRuleRequest is the request struct for api DeleteVccGrantRule
type DeleteVccGrantRuleRequest struct {
	*requests.RpcRequest
	ErId        string `position:"Body" name:"ErId"`
	InstanceId  string `position:"Body" name:"InstanceId"`
	GrantRuleId string `position:"Body" name:"GrantRuleId"`
}

// DeleteVccGrantRuleResponse is the response struct for api DeleteVccGrantRule
type DeleteVccGrantRuleResponse struct {
	*responses.BaseResponse
}

// CreateDeleteVccGrantRuleRequest creates a request to invoke DeleteVccGrantRule API
func CreateDeleteVccGrantRuleRequest() (request *DeleteVccGrantRuleRequest) {
	request = &DeleteVccGrantRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteVccGrantRule", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVccGrantRuleResponse creates a response to parse from DeleteVccGrantRule response
func CreateDeleteVccGrantRuleResponse() (response *DeleteVccGrantRuleResponse) {
	response = &DeleteVccGrantRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
