package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchAdvancedMonitoring invokes the edas.SwitchAdvancedMonitoring API synchronously
func (client *Client) SwitchAdvancedMonitoring(request *SwitchAdvancedMonitoringRequest) (response *SwitchAdvancedMonitoringResponse, err error) {
	response = CreateSwitchAdvancedMonitoringResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchAdvancedMonitoringWithChan invokes the edas.SwitchAdvancedMonitoring API asynchronously
func (client *Client) SwitchAdvancedMonitoringWithChan(request *SwitchAdvancedMonitoringRequest) (<-chan *SwitchAdvancedMonitoringResponse, <-chan error) {
	responseChan := make(chan *SwitchAdvancedMonitoringResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchAdvancedMonitoring(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchAdvancedMonitoringWithCallback invokes the edas.SwitchAdvancedMonitoring API asynchronously
func (client *Client) SwitchAdvancedMonitoringWithCallback(request *SwitchAdvancedMonitoringRequest, callback func(response *SwitchAdvancedMonitoringResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchAdvancedMonitoringResponse
		var err error
		defer close(result)
		response, err = client.SwitchAdvancedMonitoring(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchAdvancedMonitoringRequest is the request struct for api SwitchAdvancedMonitoring
type SwitchAdvancedMonitoringRequest struct {
	*requests.RoaRequest
	EnableAdvancedMonitoring requests.Boolean `position:"Query" name:"EnableAdvancedMonitoring"`
	AppId                    string           `position:"Query" name:"AppId"`
}

// SwitchAdvancedMonitoringResponse is the response struct for api SwitchAdvancedMonitoring
type SwitchAdvancedMonitoringResponse struct {
	*responses.BaseResponse
	Code                      int    `json:"Code" xml:"Code"`
	Message                   string `json:"Message" xml:"Message"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	AdvancedMonitoringEnabled bool   `json:"AdvancedMonitoringEnabled" xml:"AdvancedMonitoringEnabled"`
}

// CreateSwitchAdvancedMonitoringRequest creates a request to invoke SwitchAdvancedMonitoring API
func CreateSwitchAdvancedMonitoringRequest() (request *SwitchAdvancedMonitoringRequest) {
	request = &SwitchAdvancedMonitoringRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "SwitchAdvancedMonitoring", "/pop/v5/monitor/advancedMonitorInfo", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchAdvancedMonitoringResponse creates a response to parse from SwitchAdvancedMonitoring response
func CreateSwitchAdvancedMonitoringResponse() (response *SwitchAdvancedMonitoringResponse) {
	response = &SwitchAdvancedMonitoringResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
