package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewReservedInstances invokes the ecs.RenewReservedInstances API synchronously
func (client *Client) RenewReservedInstances(request *RenewReservedInstancesRequest) (response *RenewReservedInstancesResponse, err error) {
	response = CreateRenewReservedInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// RenewReservedInstancesWithChan invokes the ecs.RenewReservedInstances API asynchronously
func (client *Client) RenewReservedInstancesWithChan(request *RenewReservedInstancesRequest) (<-chan *RenewReservedInstancesResponse, <-chan error) {
	responseChan := make(chan *RenewReservedInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewReservedInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewReservedInstancesWithCallback invokes the ecs.RenewReservedInstances API asynchronously
func (client *Client) RenewReservedInstancesWithCallback(request *RenewReservedInstancesRequest, callback func(response *RenewReservedInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewReservedInstancesResponse
		var err error
		defer close(result)
		response, err = client.RenewReservedInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewReservedInstancesRequest is the request struct for api RenewReservedInstances
type RenewReservedInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	AutoRenewPeriod      requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period               requests.Integer `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PeriodUnit           string           `position:"Query" name:"PeriodUnit"`
	ReservedInstanceId   *[]string        `position:"Query" name:"ReservedInstanceId"  type:"Repeated"`
	AutoRenew            requests.Boolean `position:"Query" name:"AutoRenew"`
}

// RenewReservedInstancesResponse is the response struct for api RenewReservedInstances
type RenewReservedInstancesResponse struct {
	*responses.BaseResponse
	RequestId              string                                         `json:"RequestId" xml:"RequestId"`
	OrderId                string                                         `json:"OrderId" xml:"OrderId"`
	ReservedInstanceIdSets ReservedInstanceIdSetsInRenewReservedInstances `json:"ReservedInstanceIdSets" xml:"ReservedInstanceIdSets"`
}

// CreateRenewReservedInstancesRequest creates a request to invoke RenewReservedInstances API
func CreateRenewReservedInstancesRequest() (request *RenewReservedInstancesRequest) {
	request = &RenewReservedInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "RenewReservedInstances", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewReservedInstancesResponse creates a response to parse from RenewReservedInstances response
func CreateRenewReservedInstancesResponse() (response *RenewReservedInstancesResponse) {
	response = &RenewReservedInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
