package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUserFromDesktopOversoldUserGroup invokes the ecd.RemoveUserFromDesktopOversoldUserGroup API synchronously
func (client *Client) RemoveUserFromDesktopOversoldUserGroup(request *RemoveUserFromDesktopOversoldUserGroupRequest) (response *RemoveUserFromDesktopOversoldUserGroupResponse, err error) {
	response = CreateRemoveUserFromDesktopOversoldUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUserFromDesktopOversoldUserGroupWithChan invokes the ecd.RemoveUserFromDesktopOversoldUserGroup API asynchronously
func (client *Client) RemoveUserFromDesktopOversoldUserGroupWithChan(request *RemoveUserFromDesktopOversoldUserGroupRequest) (<-chan *RemoveUserFromDesktopOversoldUserGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveUserFromDesktopOversoldUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUserFromDesktopOversoldUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUserFromDesktopOversoldUserGroupWithCallback invokes the ecd.RemoveUserFromDesktopOversoldUserGroup API asynchronously
func (client *Client) RemoveUserFromDesktopOversoldUserGroupWithCallback(request *RemoveUserFromDesktopOversoldUserGroupRequest, callback func(response *RemoveUserFromDesktopOversoldUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUserFromDesktopOversoldUserGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveUserFromDesktopOversoldUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUserFromDesktopOversoldUserGroupRequest is the request struct for api RemoveUserFromDesktopOversoldUserGroup
type RemoveUserFromDesktopOversoldUserGroupRequest struct {
	*requests.RpcRequest
	OversoldGroupId string `position:"Query" name:"OversoldGroupId"`
	UserDesktopId   string `position:"Query" name:"UserDesktopId"`
	UserGroupId     string `position:"Query" name:"UserGroupId"`
	EndUserId       string `position:"Query" name:"EndUserId"`
}

// RemoveUserFromDesktopOversoldUserGroupResponse is the response struct for api RemoveUserFromDesktopOversoldUserGroup
type RemoveUserFromDesktopOversoldUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveUserFromDesktopOversoldUserGroupRequest creates a request to invoke RemoveUserFromDesktopOversoldUserGroup API
func CreateRemoveUserFromDesktopOversoldUserGroupRequest() (request *RemoveUserFromDesktopOversoldUserGroupRequest) {
	request = &RemoveUserFromDesktopOversoldUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RemoveUserFromDesktopOversoldUserGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveUserFromDesktopOversoldUserGroupResponse creates a response to parse from RemoveUserFromDesktopOversoldUserGroup response
func CreateRemoveUserFromDesktopOversoldUserGroupResponse() (response *RemoveUserFromDesktopOversoldUserGroupResponse) {
	response = &RemoveUserFromDesktopOversoldUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
