package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveCdsFile invokes the ecd.MoveCdsFile API synchronously
func (client *Client) MoveCdsFile(request *MoveCdsFileRequest) (response *MoveCdsFileResponse, err error) {
	response = CreateMoveCdsFileResponse()
	err = client.DoAction(request, response)
	return
}

// MoveCdsFileWithChan invokes the ecd.MoveCdsFile API asynchronously
func (client *Client) MoveCdsFileWithChan(request *MoveCdsFileRequest) (<-chan *MoveCdsFileResponse, <-chan error) {
	responseChan := make(chan *MoveCdsFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveCdsFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveCdsFileWithCallback invokes the ecd.MoveCdsFile API asynchronously
func (client *Client) MoveCdsFileWithCallback(request *MoveCdsFileRequest, callback func(response *MoveCdsFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveCdsFileResponse
		var err error
		defer close(result)
		response, err = client.MoveCdsFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveCdsFileRequest is the request struct for api MoveCdsFile
type MoveCdsFileRequest struct {
	*requests.RpcRequest
	GroupId        string `position:"Query" name:"GroupId"`
	CdsId          string `position:"Query" name:"CdsId"`
	ParentFolderId string `position:"Query" name:"ParentFolderId"`
	ConflictPolicy string `position:"Query" name:"ConflictPolicy"`
	EndUserId      string `position:"Query" name:"EndUserId"`
	FileId         string `position:"Query" name:"FileId"`
}

// MoveCdsFileResponse is the response struct for api MoveCdsFile
type MoveCdsFileResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Success          bool             `json:"Success" xml:"Success"`
	Code             string           `json:"Code" xml:"Code"`
	Message          string           `json:"Message" xml:"Message"`
	MoveCdsFileModel MoveCdsFileModel `json:"MoveCdsFileModel" xml:"MoveCdsFileModel"`
}

// CreateMoveCdsFileRequest creates a request to invoke MoveCdsFile API
func CreateMoveCdsFileRequest() (request *MoveCdsFileRequest) {
	request = &MoveCdsFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "MoveCdsFile", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMoveCdsFileResponse creates a response to parse from MoveCdsFile response
func CreateMoveCdsFileResponse() (response *MoveCdsFileResponse) {
	response = &MoveCdsFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
