package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopName invokes the ecd.ModifyDesktopName API synchronously
func (client *Client) ModifyDesktopName(request *ModifyDesktopNameRequest) (response *ModifyDesktopNameResponse, err error) {
	response = CreateModifyDesktopNameResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopNameWithChan invokes the ecd.ModifyDesktopName API asynchronously
func (client *Client) ModifyDesktopNameWithChan(request *ModifyDesktopNameRequest) (<-chan *ModifyDesktopNameResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopNameWithCallback invokes the ecd.ModifyDesktopName API asynchronously
func (client *Client) ModifyDesktopNameWithCallback(request *ModifyDesktopNameRequest, callback func(response *ModifyDesktopNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopNameResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopNameRequest is the request struct for api ModifyDesktopName
type ModifyDesktopNameRequest struct {
	*requests.RpcRequest
	NewDesktopName string `position:"Query" name:"NewDesktopName"`
	DesktopId      string `position:"Query" name:"DesktopId"`
}

// ModifyDesktopNameResponse is the response struct for api ModifyDesktopName
type ModifyDesktopNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDesktopNameRequest creates a request to invoke ModifyDesktopName API
func CreateModifyDesktopNameRequest() (request *ModifyDesktopNameRequest) {
	request = &ModifyDesktopNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopName", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopNameResponse creates a response to parse from ModifyDesktopName response
func CreateModifyDesktopNameResponse() (response *ModifyDesktopNameResponse) {
	response = &ModifyDesktopNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
