package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopHostName invokes the ecd.ModifyDesktopHostName API synchronously
func (client *Client) ModifyDesktopHostName(request *ModifyDesktopHostNameRequest) (response *ModifyDesktopHostNameResponse, err error) {
	response = CreateModifyDesktopHostNameResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopHostNameWithChan invokes the ecd.ModifyDesktopHostName API asynchronously
func (client *Client) ModifyDesktopHostNameWithChan(request *ModifyDesktopHostNameRequest) (<-chan *ModifyDesktopHostNameResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopHostNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopHostName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopHostNameWithCallback invokes the ecd.ModifyDesktopHostName API asynchronously
func (client *Client) ModifyDesktopHostNameWithCallback(request *ModifyDesktopHostNameRequest, callback func(response *ModifyDesktopHostNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopHostNameResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopHostName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopHostNameRequest is the request struct for api ModifyDesktopHostName
type ModifyDesktopHostNameRequest struct {
	*requests.RpcRequest
	DesktopId   string `position:"Query" name:"DesktopId"`
	NewHostName string `position:"Query" name:"NewHostName"`
}

// ModifyDesktopHostNameResponse is the response struct for api ModifyDesktopHostName
type ModifyDesktopHostNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDesktopHostNameRequest creates a request to invoke ModifyDesktopHostName API
func CreateModifyDesktopHostNameRequest() (request *ModifyDesktopHostNameRequest) {
	request = &ModifyDesktopHostNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopHostName", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopHostNameResponse creates a response to parse from ModifyDesktopHostName response
func CreateModifyDesktopHostNameResponse() (response *ModifyDesktopHostNameResponse) {
	response = &ModifyDesktopHostNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
