package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVirtualMFADevices invokes the ecd.DescribeVirtualMFADevices API synchronously
func (client *Client) DescribeVirtualMFADevices(request *DescribeVirtualMFADevicesRequest) (response *DescribeVirtualMFADevicesResponse, err error) {
	response = CreateDescribeVirtualMFADevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVirtualMFADevicesWithChan invokes the ecd.DescribeVirtualMFADevices API asynchronously
func (client *Client) DescribeVirtualMFADevicesWithChan(request *DescribeVirtualMFADevicesRequest) (<-chan *DescribeVirtualMFADevicesResponse, <-chan error) {
	responseChan := make(chan *DescribeVirtualMFADevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVirtualMFADevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVirtualMFADevicesWithCallback invokes the ecd.DescribeVirtualMFADevices API asynchronously
func (client *Client) DescribeVirtualMFADevicesWithCallback(request *DescribeVirtualMFADevicesRequest, callback func(response *DescribeVirtualMFADevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVirtualMFADevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeVirtualMFADevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVirtualMFADevicesRequest is the request struct for api DescribeVirtualMFADevices
type DescribeVirtualMFADevicesRequest struct {
	*requests.RpcRequest
	OfficeSiteId string           `position:"Query" name:"OfficeSiteId"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
	DirectoryId  string           `position:"Query" name:"DirectoryId"`
	EndUserId    *[]string        `position:"Query" name:"EndUserId"  type:"Repeated"`
}

// DescribeVirtualMFADevicesResponse is the response struct for api DescribeVirtualMFADevices
type DescribeVirtualMFADevicesResponse struct {
	*responses.BaseResponse
	NextToken         string             `json:"NextToken" xml:"NextToken"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	VirtualMFADevices []VirtualMFADevice `json:"VirtualMFADevices" xml:"VirtualMFADevices"`
}

// CreateDescribeVirtualMFADevicesRequest creates a request to invoke DescribeVirtualMFADevices API
func CreateDescribeVirtualMFADevicesRequest() (request *DescribeVirtualMFADevicesRequest) {
	request = &DescribeVirtualMFADevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeVirtualMFADevices", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVirtualMFADevicesResponse creates a response to parse from DescribeVirtualMFADevices response
func CreateDescribeVirtualMFADevicesResponse() (response *DescribeVirtualMFADevicesResponse) {
	response = &DescribeVirtualMFADevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
