package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImagePermission invokes the ecd.DescribeImagePermission API synchronously
func (client *Client) DescribeImagePermission(request *DescribeImagePermissionRequest) (response *DescribeImagePermissionResponse, err error) {
	response = CreateDescribeImagePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImagePermissionWithChan invokes the ecd.DescribeImagePermission API asynchronously
func (client *Client) DescribeImagePermissionWithChan(request *DescribeImagePermissionRequest) (<-chan *DescribeImagePermissionResponse, <-chan error) {
	responseChan := make(chan *DescribeImagePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImagePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImagePermissionWithCallback invokes the ecd.DescribeImagePermission API asynchronously
func (client *Client) DescribeImagePermissionWithCallback(request *DescribeImagePermissionRequest, callback func(response *DescribeImagePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImagePermissionResponse
		var err error
		defer close(result)
		response, err = client.DescribeImagePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImagePermissionRequest is the request struct for api DescribeImagePermission
type DescribeImagePermissionRequest struct {
	*requests.RpcRequest
	ImageId string `position:"Query" name:"ImageId"`
}

// DescribeImagePermissionResponse is the response struct for api DescribeImagePermission
type DescribeImagePermissionResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	AliUids   []string `json:"AliUids" xml:"AliUids"`
}

// CreateDescribeImagePermissionRequest creates a request to invoke DescribeImagePermission API
func CreateDescribeImagePermissionRequest() (request *DescribeImagePermissionRequest) {
	request = &DescribeImagePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeImagePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImagePermissionResponse creates a response to parse from DescribeImagePermission response
func CreateDescribeImagePermissionResponse() (response *DescribeImagePermissionResponse) {
	response = &DescribeImagePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
