package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktops invokes the ecd.DescribeDesktops API synchronously
func (client *Client) DescribeDesktops(request *DescribeDesktopsRequest) (response *DescribeDesktopsResponse, err error) {
	response = CreateDescribeDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopsWithChan invokes the ecd.DescribeDesktops API asynchronously
func (client *Client) DescribeDesktopsWithChan(request *DescribeDesktopsRequest) (<-chan *DescribeDesktopsResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopsWithCallback invokes the ecd.DescribeDesktops API asynchronously
func (client *Client) DescribeDesktopsWithCallback(request *DescribeDesktopsRequest, callback func(response *DescribeDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopsRequest is the request struct for api DescribeDesktops
type DescribeDesktopsRequest struct {
	*requests.RpcRequest
	OfficeSiteId       string                 `position:"Query" name:"OfficeSiteId"`
	SnapshotPolicyId   string                 `position:"Query" name:"SnapshotPolicyId"`
	QosRuleId          string                 `position:"Query" name:"QosRuleId"`
	ImageId            *[]string              `position:"Query" name:"ImageId"  type:"Repeated"`
	DesktopStatus      string                 `position:"Query" name:"DesktopStatus"`
	ResourceGroupId    string                 `position:"Query" name:"ResourceGroupId"`
	DesktopGroupId     string                 `position:"Query" name:"DesktopGroupId"`
	NextToken          string                 `position:"Query" name:"NextToken"`
	OnlyDesktopGroup   requests.Boolean       `position:"Query" name:"OnlyDesktopGroup"`
	QueryFotaUpdate    requests.Boolean       `position:"Query" name:"QueryFotaUpdate"`
	DirectoryId        string                 `position:"Query" name:"DirectoryId"`
	EndUserId          *[]string              `position:"Query" name:"EndUserId"  type:"Repeated"`
	DesktopId          *[]string              `position:"Query" name:"DesktopId"  type:"Repeated"`
	Tag                *[]DescribeDesktopsTag `position:"Query" name:"Tag"  type:"Repeated"`
	DesktopType        string                 `position:"Query" name:"DesktopType"`
	DesktopStatusList  *[]string              `position:"Query" name:"DesktopStatusList"  type:"Repeated"`
	DesktopName        string                 `position:"Query" name:"DesktopName"`
	GroupId            string                 `position:"Query" name:"GroupId"`
	OfficeSiteName     string                 `position:"Query" name:"OfficeSiteName"`
	ExcludedEndUserId  *[]string              `position:"Query" name:"ExcludedEndUserId"  type:"Repeated"`
	GpuInstanceGroupId string                 `position:"Query" name:"GpuInstanceGroupId"`
	FilterDesktopGroup requests.Boolean       `position:"Query" name:"FilterDesktopGroup"`
	ManagementFlag     string                 `position:"Query" name:"ManagementFlag"`
	SubPayType         string                 `position:"Query" name:"SubPayType"`
	ExpiredTime        string                 `position:"Query" name:"ExpiredTime"`
	MaxResults         requests.Integer       `position:"Query" name:"MaxResults"`
	FillResourceGroup  requests.Boolean       `position:"Query" name:"FillResourceGroup"`
	OsTypes            *[]string              `position:"Query" name:"OsTypes"  type:"Repeated"`
	ProtocolType       string                 `position:"Query" name:"ProtocolType"`
	ChargeType         string                 `position:"Query" name:"ChargeType"`
	PolicyGroupId      string                 `position:"Query" name:"PolicyGroupId"`
	UserName           string                 `position:"Query" name:"UserName"`
}

// DescribeDesktopsTag is a repeated param struct in DescribeDesktopsRequest
type DescribeDesktopsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDesktopsResponse is the response struct for api DescribeDesktops
type DescribeDesktopsResponse struct {
	*responses.BaseResponse
	NextToken  string                      `json:"NextToken" xml:"NextToken"`
	RequestId  string                      `json:"RequestId" xml:"RequestId"`
	TotalCount int                         `json:"TotalCount" xml:"TotalCount"`
	Desktops   []DesktopInDescribeDesktops `json:"Desktops" xml:"Desktops"`
}

// CreateDescribeDesktopsRequest creates a request to invoke DescribeDesktops API
func CreateDescribeDesktopsRequest() (request *DescribeDesktopsRequest) {
	request = &DescribeDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktops", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopsResponse creates a response to parse from DescribeDesktops response
func CreateDescribeDesktopsResponse() (response *DescribeDesktopsResponse) {
	response = &DescribeDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
