package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDevices invokes the ecd.AddDevices API synchronously
func (client *Client) AddDevices(request *AddDevicesRequest) (response *AddDevicesResponse, err error) {
	response = CreateAddDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// AddDevicesWithChan invokes the ecd.AddDevices API asynchronously
func (client *Client) AddDevicesWithChan(request *AddDevicesRequest) (<-chan *AddDevicesResponse, <-chan error) {
	responseChan := make(chan *AddDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDevicesWithCallback invokes the ecd.AddDevices API asynchronously
func (client *Client) AddDevicesWithCallback(request *AddDevicesRequest, callback func(response *AddDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDevicesResponse
		var err error
		defer close(result)
		response, err = client.AddDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDevicesRequest is the request struct for api AddDevices
type AddDevicesRequest struct {
	*requests.RpcRequest
	ClientType requests.Integer `position:"Query" name:"ClientType"`
	DeviceIds  *[]string        `position:"Query" name:"DeviceIds"  type:"Repeated"`
}

// AddDevicesResponse is the response struct for api AddDevices
type AddDevicesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateAddDevicesRequest creates a request to invoke AddDevices API
func CreateAddDevicesRequest() (request *AddDevicesRequest) {
	request = &AddDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AddDevices", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDevicesResponse creates a response to parse from AddDevices response
func CreateAddDevicesResponse() (response *AddDevicesResponse) {
	response = &AddDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
