package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEais invokes the eais.DescribeEais API synchronously
func (client *Client) DescribeEais(request *DescribeEaisRequest) (response *DescribeEaisResponse, err error) {
	response = CreateDescribeEaisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEaisWithChan invokes the eais.DescribeEais API asynchronously
func (client *Client) DescribeEaisWithChan(request *DescribeEaisRequest) (<-chan *DescribeEaisResponse, <-chan error) {
	responseChan := make(chan *DescribeEaisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEais(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEaisWithCallback invokes the eais.DescribeEais API asynchronously
func (client *Client) DescribeEaisWithCallback(request *DescribeEaisRequest, callback func(response *DescribeEaisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEaisResponse
		var err error
		defer close(result)
		response, err = client.DescribeEais(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEaisRequest is the request struct for api DescribeEais
type DescribeEaisRequest struct {
	*requests.RpcRequest
	ElasticAcceleratedInstanceIds string             `position:"Query" name:"ElasticAcceleratedInstanceIds"`
	PageNumber                    requests.Integer   `position:"Query" name:"PageNumber"`
	ResourceGroupId               string             `position:"Query" name:"ResourceGroupId"`
	PageSize                      requests.Integer   `position:"Query" name:"PageSize"`
	InstanceType                  string             `position:"Query" name:"InstanceType"`
	Tag                           *[]DescribeEaisTag `position:"Query" name:"Tag"  type:"Repeated"`
	ClientInstanceId              string             `position:"Query" name:"ClientInstanceId"`
	InstanceName                  string             `position:"Query" name:"InstanceName"`
	Status                        string             `position:"Query" name:"Status"`
}

// DescribeEaisTag is a repeated param struct in DescribeEaisRequest
type DescribeEaisTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeEaisResponse is the response struct for api DescribeEais
type DescribeEaisResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	Instances  Instances `json:"Instances" xml:"Instances"`
}

// CreateDescribeEaisRequest creates a request to invoke DescribeEais API
func CreateDescribeEaisRequest() (request *DescribeEaisRequest) {
	request = &DescribeEaisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "DescribeEais", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEaisResponse creates a response to parse from DescribeEais response
func CreateDescribeEaisResponse() (response *DescribeEaisResponse) {
	response = &DescribeEaisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
