package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIntlFixedPriceOrderList invokes the domain.QueryIntlFixedPriceOrderList API synchronously
func (client *Client) QueryIntlFixedPriceOrderList(request *QueryIntlFixedPriceOrderListRequest) (response *QueryIntlFixedPriceOrderListResponse, err error) {
	response = CreateQueryIntlFixedPriceOrderListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIntlFixedPriceOrderListWithChan invokes the domain.QueryIntlFixedPriceOrderList API asynchronously
func (client *Client) QueryIntlFixedPriceOrderListWithChan(request *QueryIntlFixedPriceOrderListRequest) (<-chan *QueryIntlFixedPriceOrderListResponse, <-chan error) {
	responseChan := make(chan *QueryIntlFixedPriceOrderListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIntlFixedPriceOrderList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIntlFixedPriceOrderListWithCallback invokes the domain.QueryIntlFixedPriceOrderList API asynchronously
func (client *Client) QueryIntlFixedPriceOrderListWithCallback(request *QueryIntlFixedPriceOrderListRequest, callback func(response *QueryIntlFixedPriceOrderListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIntlFixedPriceOrderListResponse
		var err error
		defer close(result)
		response, err = client.QueryIntlFixedPriceOrderList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIntlFixedPriceOrderListRequest is the request struct for api QueryIntlFixedPriceOrderList
type QueryIntlFixedPriceOrderListRequest struct {
	*requests.RpcRequest
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	BizId       string           `position:"Query" name:"BizId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Status      requests.Integer `position:"Query" name:"Status"`
}

// QueryIntlFixedPriceOrderListResponse is the response struct for api QueryIntlFixedPriceOrderList
type QueryIntlFixedPriceOrderListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    Module `json:"Module" xml:"Module"`
}

// CreateQueryIntlFixedPriceOrderListRequest creates a request to invoke QueryIntlFixedPriceOrderList API
func CreateQueryIntlFixedPriceOrderListRequest() (request *QueryIntlFixedPriceOrderListRequest) {
	request = &QueryIntlFixedPriceOrderListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryIntlFixedPriceOrderList", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryIntlFixedPriceOrderListResponse creates a response to parse from QueryIntlFixedPriceOrderList response
func CreateQueryIntlFixedPriceOrderListResponse() (response *QueryIntlFixedPriceOrderListResponse) {
	response = &QueryIntlFixedPriceOrderListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
