package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDomainSpecialBizDetail invokes the domain.QueryDomainSpecialBizDetail API synchronously
func (client *Client) QueryDomainSpecialBizDetail(request *QueryDomainSpecialBizDetailRequest) (response *QueryDomainSpecialBizDetailResponse, err error) {
	response = CreateQueryDomainSpecialBizDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDomainSpecialBizDetailWithChan invokes the domain.QueryDomainSpecialBizDetail API asynchronously
func (client *Client) QueryDomainSpecialBizDetailWithChan(request *QueryDomainSpecialBizDetailRequest) (<-chan *QueryDomainSpecialBizDetailResponse, <-chan error) {
	responseChan := make(chan *QueryDomainSpecialBizDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDomainSpecialBizDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDomainSpecialBizDetailWithCallback invokes the domain.QueryDomainSpecialBizDetail API asynchronously
func (client *Client) QueryDomainSpecialBizDetailWithCallback(request *QueryDomainSpecialBizDetailRequest, callback func(response *QueryDomainSpecialBizDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDomainSpecialBizDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryDomainSpecialBizDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDomainSpecialBizDetailRequest is the request struct for api QueryDomainSpecialBizDetail
type QueryDomainSpecialBizDetailRequest struct {
	*requests.RpcRequest
	BizId        requests.Integer `position:"Body" name:"BizId"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
}

// QueryDomainSpecialBizDetailResponse is the response struct for api QueryDomainSpecialBizDetail
type QueryDomainSpecialBizDetailResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	Synchro        bool     `json:"Synchro" xml:"Synchro"`
	ErrorMsg       string   `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool     `json:"Success" xml:"Success"`
	AllowRetry     bool     `json:"AllowRetry" xml:"AllowRetry"`
	AppName        string   `json:"AppName" xml:"AppName"`
	ErrorArgs      []string `json:"ErrorArgs" xml:"ErrorArgs"`
	Module         Module   `json:"Module" xml:"Module"`
}

// CreateQueryDomainSpecialBizDetailRequest creates a request to invoke QueryDomainSpecialBizDetail API
func CreateQueryDomainSpecialBizDetailRequest() (request *QueryDomainSpecialBizDetailRequest) {
	request = &QueryDomainSpecialBizDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryDomainSpecialBizDetail", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDomainSpecialBizDetailResponse creates a response to parse from QueryDomainSpecialBizDetail response
func CreateQueryDomainSpecialBizDetailResponse() (response *QueryDomainSpecialBizDetailResponse) {
	response = &QueryDomainSpecialBizDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
