package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FuzzyMatchDomainSensitiveWord invokes the domain.FuzzyMatchDomainSensitiveWord API synchronously
func (client *Client) FuzzyMatchDomainSensitiveWord(request *FuzzyMatchDomainSensitiveWordRequest) (response *FuzzyMatchDomainSensitiveWordResponse, err error) {
	response = CreateFuzzyMatchDomainSensitiveWordResponse()
	err = client.DoAction(request, response)
	return
}

// FuzzyMatchDomainSensitiveWordWithChan invokes the domain.FuzzyMatchDomainSensitiveWord API asynchronously
func (client *Client) FuzzyMatchDomainSensitiveWordWithChan(request *FuzzyMatchDomainSensitiveWordRequest) (<-chan *FuzzyMatchDomainSensitiveWordResponse, <-chan error) {
	responseChan := make(chan *FuzzyMatchDomainSensitiveWordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FuzzyMatchDomainSensitiveWord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FuzzyMatchDomainSensitiveWordWithCallback invokes the domain.FuzzyMatchDomainSensitiveWord API asynchronously
func (client *Client) FuzzyMatchDomainSensitiveWordWithCallback(request *FuzzyMatchDomainSensitiveWordRequest, callback func(response *FuzzyMatchDomainSensitiveWordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FuzzyMatchDomainSensitiveWordResponse
		var err error
		defer close(result)
		response, err = client.FuzzyMatchDomainSensitiveWord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FuzzyMatchDomainSensitiveWordRequest is the request struct for api FuzzyMatchDomainSensitiveWord
type FuzzyMatchDomainSensitiveWordRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Keyword      string `position:"Query" name:"Keyword"`
	Lang         string `position:"Query" name:"Lang"`
}

// FuzzyMatchDomainSensitiveWordResponse is the response struct for api FuzzyMatchDomainSensitiveWord
type FuzzyMatchDomainSensitiveWordResponse struct {
	*responses.BaseResponse
	Exist               bool                                               `json:"Exist" xml:"Exist"`
	RequestId           string                                             `json:"RequestId" xml:"RequestId"`
	Keyword             string                                             `json:"Keyword" xml:"Keyword"`
	MatchedSentiveWords MatchedSentiveWordsInFuzzyMatchDomainSensitiveWord `json:"MatchedSentiveWords" xml:"MatchedSentiveWords"`
}

// CreateFuzzyMatchDomainSensitiveWordRequest creates a request to invoke FuzzyMatchDomainSensitiveWord API
func CreateFuzzyMatchDomainSensitiveWordRequest() (request *FuzzyMatchDomainSensitiveWordRequest) {
	request = &FuzzyMatchDomainSensitiveWordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "FuzzyMatchDomainSensitiveWord", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFuzzyMatchDomainSensitiveWordResponse creates a response to parse from FuzzyMatchDomainSensitiveWord response
func CreateFuzzyMatchDomainSensitiveWordResponse() (response *FuzzyMatchDomainSensitiveWordResponse) {
	response = &FuzzyMatchDomainSensitiveWordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
