package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckProcessingServerLockApply invokes the domain.CheckProcessingServerLockApply API synchronously
func (client *Client) CheckProcessingServerLockApply(request *CheckProcessingServerLockApplyRequest) (response *CheckProcessingServerLockApplyResponse, err error) {
	response = CreateCheckProcessingServerLockApplyResponse()
	err = client.DoAction(request, response)
	return
}

// CheckProcessingServerLockApplyWithChan invokes the domain.CheckProcessingServerLockApply API asynchronously
func (client *Client) CheckProcessingServerLockApplyWithChan(request *CheckProcessingServerLockApplyRequest) (<-chan *CheckProcessingServerLockApplyResponse, <-chan error) {
	responseChan := make(chan *CheckProcessingServerLockApplyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckProcessingServerLockApply(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckProcessingServerLockApplyWithCallback invokes the domain.CheckProcessingServerLockApply API asynchronously
func (client *Client) CheckProcessingServerLockApplyWithCallback(request *CheckProcessingServerLockApplyRequest, callback func(response *CheckProcessingServerLockApplyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckProcessingServerLockApplyResponse
		var err error
		defer close(result)
		response, err = client.CheckProcessingServerLockApply(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckProcessingServerLockApplyRequest is the request struct for api CheckProcessingServerLockApply
type CheckProcessingServerLockApplyRequest struct {
	*requests.RpcRequest
	DomainName   string           `position:"Query" name:"DomainName"`
	FeePeriod    requests.Integer `position:"Query" name:"FeePeriod"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	Lang         string           `position:"Query" name:"Lang"`
}

// CheckProcessingServerLockApplyResponse is the response struct for api CheckProcessingServerLockApply
type CheckProcessingServerLockApplyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Exists    bool   `json:"Exists" xml:"Exists"`
}

// CreateCheckProcessingServerLockApplyRequest creates a request to invoke CheckProcessingServerLockApply API
func CreateCheckProcessingServerLockApplyRequest() (request *CheckProcessingServerLockApplyRequest) {
	request = &CheckProcessingServerLockApplyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "CheckProcessingServerLockApply", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckProcessingServerLockApplyResponse creates a response to parse from CheckProcessingServerLockApply response
func CreateCheckProcessingServerLockApplyResponse() (response *CheckProcessingServerLockApplyResponse) {
	response = &CheckProcessingServerLockApplyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
