package documentautoml

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictTemplateModel invokes the documentautoml.PredictTemplateModel API synchronously
func (client *Client) PredictTemplateModel(request *PredictTemplateModelRequest) (response *PredictTemplateModelResponse, err error) {
	response = CreatePredictTemplateModelResponse()
	err = client.DoAction(request, response)
	return
}

// PredictTemplateModelWithChan invokes the documentautoml.PredictTemplateModel API asynchronously
func (client *Client) PredictTemplateModelWithChan(request *PredictTemplateModelRequest) (<-chan *PredictTemplateModelResponse, <-chan error) {
	responseChan := make(chan *PredictTemplateModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictTemplateModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictTemplateModelWithCallback invokes the documentautoml.PredictTemplateModel API asynchronously
func (client *Client) PredictTemplateModelWithCallback(request *PredictTemplateModelRequest, callback func(response *PredictTemplateModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictTemplateModelResponse
		var err error
		defer close(result)
		response, err = client.PredictTemplateModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictTemplateModelRequest is the request struct for api PredictTemplateModel
type PredictTemplateModelRequest struct {
	*requests.RpcRequest
	Body         string           `position:"Body" name:"body"`
	Content      string           `position:"Query" name:"Content"`
	BinaryToText requests.Boolean `position:"Query" name:"BinaryToText"`
	TaskId       requests.Integer `position:"Query" name:"TaskId"`
	Product      string           `position:"Query" name:"Product"`
}

// PredictTemplateModelResponse is the response struct for api PredictTemplateModel
type PredictTemplateModelResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Message   string                 `json:"Message" xml:"Message"`
	Code      string                 `json:"Code" xml:"Code"`
}

// CreatePredictTemplateModelRequest creates a request to invoke PredictTemplateModel API
func CreatePredictTemplateModelRequest() (request *PredictTemplateModelRequest) {
	request = &PredictTemplateModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("documentAutoml", "2022-12-29", "PredictTemplateModel", "documentAutoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePredictTemplateModelResponse creates a response to parse from PredictTemplateModel response
func CreatePredictTemplateModelResponse() (response *PredictTemplateModelResponse) {
	response = &PredictTemplateModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
