package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReRunTaskFlowInstance invokes the dms_enterprise.ReRunTaskFlowInstance API synchronously
func (client *Client) ReRunTaskFlowInstance(request *ReRunTaskFlowInstanceRequest) (response *ReRunTaskFlowInstanceResponse, err error) {
	response = CreateReRunTaskFlowInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReRunTaskFlowInstanceWithChan invokes the dms_enterprise.ReRunTaskFlowInstance API asynchronously
func (client *Client) ReRunTaskFlowInstanceWithChan(request *ReRunTaskFlowInstanceRequest) (<-chan *ReRunTaskFlowInstanceResponse, <-chan error) {
	responseChan := make(chan *ReRunTaskFlowInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReRunTaskFlowInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReRunTaskFlowInstanceWithCallback invokes the dms_enterprise.ReRunTaskFlowInstance API asynchronously
func (client *Client) ReRunTaskFlowInstanceWithCallback(request *ReRunTaskFlowInstanceRequest, callback func(response *ReRunTaskFlowInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReRunTaskFlowInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReRunTaskFlowInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReRunTaskFlowInstanceRequest is the request struct for api ReRunTaskFlowInstance
type ReRunTaskFlowInstanceRequest struct {
	*requests.RpcRequest
	DagId         requests.Integer `position:"Query" name:"DagId"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
	DagVersion    string           `position:"Query" name:"DagVersion"`
	DagInstanceId requests.Integer `position:"Query" name:"DagInstanceId"`
}

// ReRunTaskFlowInstanceResponse is the response struct for api ReRunTaskFlowInstance
type ReRunTaskFlowInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateReRunTaskFlowInstanceRequest creates a request to invoke ReRunTaskFlowInstance API
func CreateReRunTaskFlowInstanceRequest() (request *ReRunTaskFlowInstanceRequest) {
	request = &ReRunTaskFlowInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ReRunTaskFlowInstance", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReRunTaskFlowInstanceResponse creates a response to parse from ReRunTaskFlowInstance response
func CreateReRunTaskFlowInstanceResponse() (response *ReRunTaskFlowInstanceResponse) {
	response = &ReRunTaskFlowInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
