package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthorizedDatabasesForUser invokes the dms_enterprise.ListAuthorizedDatabasesForUser API synchronously
func (client *Client) ListAuthorizedDatabasesForUser(request *ListAuthorizedDatabasesForUserRequest) (response *ListAuthorizedDatabasesForUserResponse, err error) {
	response = CreateListAuthorizedDatabasesForUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthorizedDatabasesForUserWithChan invokes the dms_enterprise.ListAuthorizedDatabasesForUser API asynchronously
func (client *Client) ListAuthorizedDatabasesForUserWithChan(request *ListAuthorizedDatabasesForUserRequest) (<-chan *ListAuthorizedDatabasesForUserResponse, <-chan error) {
	responseChan := make(chan *ListAuthorizedDatabasesForUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthorizedDatabasesForUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthorizedDatabasesForUserWithCallback invokes the dms_enterprise.ListAuthorizedDatabasesForUser API asynchronously
func (client *Client) ListAuthorizedDatabasesForUserWithCallback(request *ListAuthorizedDatabasesForUserRequest, callback func(response *ListAuthorizedDatabasesForUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthorizedDatabasesForUserResponse
		var err error
		defer close(result)
		response, err = client.ListAuthorizedDatabasesForUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthorizedDatabasesForUserRequest is the request struct for api ListAuthorizedDatabasesForUser
type ListAuthorizedDatabasesForUserRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Query" name:"SearchKey"`
	UserId     string           `position:"Query" name:"UserId"`
	PageNumber string           `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	EnvType    string           `position:"Query" name:"EnvType"`
	PageSize   string           `position:"Query" name:"PageSize"`
	DbType     string           `position:"Query" name:"DbType"`
	Logic      requests.Boolean `position:"Query" name:"Logic"`
}

// ListAuthorizedDatabasesForUserResponse is the response struct for api ListAuthorizedDatabasesForUser
type ListAuthorizedDatabasesForUserResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Databases []DatabasesItem `json:"Databases" xml:"Databases"`
}

// CreateListAuthorizedDatabasesForUserRequest creates a request to invoke ListAuthorizedDatabasesForUser API
func CreateListAuthorizedDatabasesForUserRequest() (request *ListAuthorizedDatabasesForUserRequest) {
	request = &ListAuthorizedDatabasesForUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListAuthorizedDatabasesForUser", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthorizedDatabasesForUserResponse creates a response to parse from ListAuthorizedDatabasesForUser response
func CreateListAuthorizedDatabasesForUserResponse() (response *ListAuthorizedDatabasesForUserResponse) {
	response = &ListAuthorizedDatabasesForUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
