package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLhMembers invokes the dms_enterprise.DeleteLhMembers API synchronously
func (client *Client) DeleteLhMembers(request *DeleteLhMembersRequest) (response *DeleteLhMembersResponse, err error) {
	response = CreateDeleteLhMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLhMembersWithChan invokes the dms_enterprise.DeleteLhMembers API asynchronously
func (client *Client) DeleteLhMembersWithChan(request *DeleteLhMembersRequest) (<-chan *DeleteLhMembersResponse, <-chan error) {
	responseChan := make(chan *DeleteLhMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLhMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLhMembersWithCallback invokes the dms_enterprise.DeleteLhMembers API asynchronously
func (client *Client) DeleteLhMembersWithCallback(request *DeleteLhMembersRequest, callback func(response *DeleteLhMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLhMembersResponse
		var err error
		defer close(result)
		response, err = client.DeleteLhMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLhMembersRequest is the request struct for api DeleteLhMembers
type DeleteLhMembersRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	ObjectType requests.Integer `position:"Query" name:"ObjectType"`
	MemberIds  *[]string        `position:"Query" name:"MemberIds"  type:"Json"`
	ObjectId   requests.Integer `position:"Query" name:"ObjectId"`
}

// DeleteLhMembersResponse is the response struct for api DeleteLhMembers
type DeleteLhMembersResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteLhMembersRequest creates a request to invoke DeleteLhMembers API
func CreateDeleteLhMembersRequest() (request *DeleteLhMembersRequest) {
	request = &DeleteLhMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteLhMembers", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLhMembersResponse creates a response to parse from DeleteLhMembers response
func CreateDeleteLhMembersResponse() (response *DeleteLhMembersResponse) {
	response = &DeleteLhMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
