package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUploadFileJob invokes the dms_enterprise.CreateUploadFileJob API synchronously
func (client *Client) CreateUploadFileJob(request *CreateUploadFileJobRequest) (response *CreateUploadFileJobResponse, err error) {
	response = CreateCreateUploadFileJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUploadFileJobWithChan invokes the dms_enterprise.CreateUploadFileJob API asynchronously
func (client *Client) CreateUploadFileJobWithChan(request *CreateUploadFileJobRequest) (<-chan *CreateUploadFileJobResponse, <-chan error) {
	responseChan := make(chan *CreateUploadFileJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUploadFileJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUploadFileJobWithCallback invokes the dms_enterprise.CreateUploadFileJob API asynchronously
func (client *Client) CreateUploadFileJobWithCallback(request *CreateUploadFileJobRequest, callback func(response *CreateUploadFileJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUploadFileJobResponse
		var err error
		defer close(result)
		response, err = client.CreateUploadFileJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUploadFileJobRequest is the request struct for api CreateUploadFileJob
type CreateUploadFileJobRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	UploadURL  string           `position:"Query" name:"UploadURL"`
	UploadType string           `position:"Query" name:"UploadType"`
	FileSource string           `position:"Query" name:"FileSource"`
	FileName   string           `position:"Query" name:"FileName"`
}

// CreateUploadFileJobResponse is the response struct for api CreateUploadFileJob
type CreateUploadFileJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	JobKey       string `json:"JobKey" xml:"JobKey"`
}

// CreateCreateUploadFileJobRequest creates a request to invoke CreateUploadFileJob API
func CreateCreateUploadFileJobRequest() (request *CreateUploadFileJobRequest) {
	request = &CreateUploadFileJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateUploadFileJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateUploadFileJobResponse creates a response to parse from CreateUploadFileJob response
func CreateCreateUploadFileJobResponse() (response *CreateUploadFileJobResponse) {
	response = &CreateUploadFileJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
