package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteReceiver invokes the dm.DeleteReceiver API synchronously
// api document: https://help.aliyun.com/api/dm/deletereceiver.html
func (client *Client) DeleteReceiver(request *DeleteReceiverRequest) (response *DeleteReceiverResponse, err error) {
	response = CreateDeleteReceiverResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteReceiverWithChan invokes the dm.DeleteReceiver API asynchronously
// api document: https://help.aliyun.com/api/dm/deletereceiver.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteReceiverWithChan(request *DeleteReceiverRequest) (<-chan *DeleteReceiverResponse, <-chan error) {
	responseChan := make(chan *DeleteReceiverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteReceiver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteReceiverWithCallback invokes the dm.DeleteReceiver API asynchronously
// api document: https://help.aliyun.com/api/dm/deletereceiver.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteReceiverWithCallback(request *DeleteReceiverRequest, callback func(response *DeleteReceiverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteReceiverResponse
		var err error
		defer close(result)
		response, err = client.DeleteReceiver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteReceiverRequest is the request struct for api DeleteReceiver
type DeleteReceiverRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReceiverId           string           `position:"Query" name:"ReceiverId"`
}

// DeleteReceiverResponse is the response struct for api DeleteReceiver
type DeleteReceiverResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteReceiverRequest creates a request to invoke DeleteReceiver API
func CreateDeleteReceiverRequest() (request *DeleteReceiverRequest) {
	request = &DeleteReceiverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "DeleteReceiver", "", "")
	return
}

// CreateDeleteReceiverResponse creates a response to parse from DeleteReceiver response
func CreateDeleteReceiverResponse() (response *DeleteReceiverResponse) {
	response = &DeleteReceiverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
