package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskDetailActivity invokes the devops_rdc.GetTaskDetailActivity API synchronously
func (client *Client) GetTaskDetailActivity(request *GetTaskDetailActivityRequest) (response *GetTaskDetailActivityResponse, err error) {
	response = CreateGetTaskDetailActivityResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskDetailActivityWithChan invokes the devops_rdc.GetTaskDetailActivity API asynchronously
func (client *Client) GetTaskDetailActivityWithChan(request *GetTaskDetailActivityRequest) (<-chan *GetTaskDetailActivityResponse, <-chan error) {
	responseChan := make(chan *GetTaskDetailActivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskDetailActivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskDetailActivityWithCallback invokes the devops_rdc.GetTaskDetailActivity API asynchronously
func (client *Client) GetTaskDetailActivityWithCallback(request *GetTaskDetailActivityRequest, callback func(response *GetTaskDetailActivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskDetailActivityResponse
		var err error
		defer close(result)
		response, err = client.GetTaskDetailActivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskDetailActivityRequest is the request struct for api GetTaskDetailActivity
type GetTaskDetailActivityRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
	TaskId    string `position:"Body" name:"TaskId"`
}

// GetTaskDetailActivityResponse is the response struct for api GetTaskDetailActivity
type GetTaskDetailActivityResponse struct {
	*responses.BaseResponse
	Successful     bool       `json:"Successful" xml:"Successful"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg       string     `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Object         []Activity `json:"Object" xml:"Object"`
}

// CreateGetTaskDetailActivityRequest creates a request to invoke GetTaskDetailActivity API
func CreateGetTaskDetailActivityRequest() (request *GetTaskDetailActivityRequest) {
	request = &GetTaskDetailActivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetTaskDetailActivity", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTaskDetailActivityResponse creates a response to parse from GetTaskDetailActivity response
func CreateGetTaskDetailActivityResponse() (response *GetTaskDetailActivityResponse) {
	response = &GetTaskDetailActivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
