package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTlsConfig invokes the ddoscoo.ModifyTlsConfig API synchronously
func (client *Client) ModifyTlsConfig(request *ModifyTlsConfigRequest) (response *ModifyTlsConfigResponse, err error) {
	response = CreateModifyTlsConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTlsConfigWithChan invokes the ddoscoo.ModifyTlsConfig API asynchronously
func (client *Client) ModifyTlsConfigWithChan(request *ModifyTlsConfigRequest) (<-chan *ModifyTlsConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyTlsConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTlsConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTlsConfigWithCallback invokes the ddoscoo.ModifyTlsConfig API asynchronously
func (client *Client) ModifyTlsConfigWithCallback(request *ModifyTlsConfigRequest, callback func(response *ModifyTlsConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTlsConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyTlsConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTlsConfigRequest is the request struct for api ModifyTlsConfig
type ModifyTlsConfigRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Config          string `position:"Query" name:"Config"`
}

// ModifyTlsConfigResponse is the response struct for api ModifyTlsConfig
type ModifyTlsConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTlsConfigRequest creates a request to invoke ModifyTlsConfig API
func CreateModifyTlsConfigRequest() (request *ModifyTlsConfigRequest) {
	request = &ModifyTlsConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyTlsConfig", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTlsConfigResponse creates a response to parse from ModifyTlsConfig response
func CreateModifyTlsConfigResponse() (response *ModifyTlsConfigResponse) {
	response = &ModifyTlsConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
