package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNetworkRuleAttribute invokes the ddoscoo.ModifyNetworkRuleAttribute API synchronously
func (client *Client) ModifyNetworkRuleAttribute(request *ModifyNetworkRuleAttributeRequest) (response *ModifyNetworkRuleAttributeResponse, err error) {
	response = CreateModifyNetworkRuleAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNetworkRuleAttributeWithChan invokes the ddoscoo.ModifyNetworkRuleAttribute API asynchronously
func (client *Client) ModifyNetworkRuleAttributeWithChan(request *ModifyNetworkRuleAttributeRequest) (<-chan *ModifyNetworkRuleAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyNetworkRuleAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNetworkRuleAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNetworkRuleAttributeWithCallback invokes the ddoscoo.ModifyNetworkRuleAttribute API asynchronously
func (client *Client) ModifyNetworkRuleAttributeWithCallback(request *ModifyNetworkRuleAttributeRequest, callback func(response *ModifyNetworkRuleAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNetworkRuleAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyNetworkRuleAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNetworkRuleAttributeRequest is the request struct for api ModifyNetworkRuleAttribute
type ModifyNetworkRuleAttributeRequest struct {
	*requests.RpcRequest
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	FrontendPort    requests.Integer `position:"Query" name:"FrontendPort"`
	ForwardProtocol string           `position:"Query" name:"ForwardProtocol"`
	Config          string           `position:"Query" name:"Config"`
}

// ModifyNetworkRuleAttributeResponse is the response struct for api ModifyNetworkRuleAttribute
type ModifyNetworkRuleAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNetworkRuleAttributeRequest creates a request to invoke ModifyNetworkRuleAttribute API
func CreateModifyNetworkRuleAttributeRequest() (request *ModifyNetworkRuleAttributeRequest) {
	request = &ModifyNetworkRuleAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyNetworkRuleAttribute", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNetworkRuleAttributeResponse creates a response to parse from ModifyNetworkRuleAttribute response
func CreateModifyNetworkRuleAttributeResponse() (response *ModifyNetworkRuleAttributeResponse) {
	response = &ModifyNetworkRuleAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
