package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHeaders invokes the ddoscoo.ModifyHeaders API synchronously
func (client *Client) ModifyHeaders(request *ModifyHeadersRequest) (response *ModifyHeadersResponse, err error) {
	response = CreateModifyHeadersResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHeadersWithChan invokes the ddoscoo.ModifyHeaders API asynchronously
func (client *Client) ModifyHeadersWithChan(request *ModifyHeadersRequest) (<-chan *ModifyHeadersResponse, <-chan error) {
	responseChan := make(chan *ModifyHeadersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHeaders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHeadersWithCallback invokes the ddoscoo.ModifyHeaders API asynchronously
func (client *Client) ModifyHeadersWithCallback(request *ModifyHeadersRequest, callback func(response *ModifyHeadersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHeadersResponse
		var err error
		defer close(result)
		response, err = client.ModifyHeaders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHeadersRequest is the request struct for api ModifyHeaders
type ModifyHeadersRequest struct {
	*requests.RpcRequest
	CustomHeaders   string `position:"Query" name:"CustomHeaders"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// ModifyHeadersResponse is the response struct for api ModifyHeaders
type ModifyHeadersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyHeadersRequest creates a request to invoke ModifyHeaders API
func CreateModifyHeadersRequest() (request *ModifyHeadersRequest) {
	request = &ModifyHeadersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyHeaders", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHeadersResponse creates a response to parse from ModifyHeaders response
func CreateModifyHeadersResponse() (response *ModifyHeadersResponse) {
	response = &ModifyHeadersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
