package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceExt invokes the ddoscoo.DescribeInstanceExt API synchronously
func (client *Client) DescribeInstanceExt(request *DescribeInstanceExtRequest) (response *DescribeInstanceExtResponse, err error) {
	response = CreateDescribeInstanceExtResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceExtWithChan invokes the ddoscoo.DescribeInstanceExt API asynchronously
func (client *Client) DescribeInstanceExtWithChan(request *DescribeInstanceExtRequest) (<-chan *DescribeInstanceExtResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceExtResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceExt(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceExtWithCallback invokes the ddoscoo.DescribeInstanceExt API asynchronously
func (client *Client) DescribeInstanceExtWithCallback(request *DescribeInstanceExtRequest, callback func(response *DescribeInstanceExtResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceExtResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceExt(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceExtRequest is the request struct for api DescribeInstanceExt
type DescribeInstanceExtRequest struct {
	*requests.RpcRequest
	PageNumber string `position:"Query" name:"PageNumber"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	PageSize   string `position:"Query" name:"PageSize"`
}

// DescribeInstanceExtResponse is the response struct for api DescribeInstanceExt
type DescribeInstanceExtResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int64                  `json:"TotalCount" xml:"TotalCount"`
	InstanceExtSpecs []InstanceExtSpecsItem `json:"InstanceExtSpecs" xml:"InstanceExtSpecs"`
}

// CreateDescribeInstanceExtRequest creates a request to invoke DescribeInstanceExt API
func CreateDescribeInstanceExtRequest() (request *DescribeInstanceExtRequest) {
	request = &DescribeInstanceExtRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeInstanceExt", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceExtResponse creates a response to parse from DescribeInstanceExt response
func CreateDescribeInstanceExtResponse() (response *DescribeInstanceExtResponse) {
	response = &DescribeInstanceExtResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
