package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKvUsageData invokes the dcdn.DescribeKvUsageData API synchronously
func (client *Client) DescribeKvUsageData(request *DescribeKvUsageDataRequest) (response *DescribeKvUsageDataResponse, err error) {
	response = CreateDescribeKvUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKvUsageDataWithChan invokes the dcdn.DescribeKvUsageData API asynchronously
func (client *Client) DescribeKvUsageDataWithChan(request *DescribeKvUsageDataRequest) (<-chan *DescribeKvUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeKvUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKvUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKvUsageDataWithCallback invokes the dcdn.DescribeKvUsageData API asynchronously
func (client *Client) DescribeKvUsageDataWithCallback(request *DescribeKvUsageDataRequest, callback func(response *DescribeKvUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKvUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeKvUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKvUsageDataRequest is the request struct for api DescribeKvUsageData
type DescribeKvUsageDataRequest struct {
	*requests.RpcRequest
	AccessType   string `position:"Query" name:"AccessType"`
	Field        string `position:"Query" name:"Field"`
	NamespaceId  string `position:"Query" name:"NamespaceId"`
	EndTime      string `position:"Query" name:"EndTime"`
	StartTime    string `position:"Query" name:"StartTime"`
	ResponseType string `position:"Query" name:"ResponseType"`
	SplitBy      string `position:"Query" name:"SplitBy"`
}

// DescribeKvUsageDataResponse is the response struct for api DescribeKvUsageData
type DescribeKvUsageDataResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	StartTime   string            `json:"StartTime" xml:"StartTime"`
	EndTime     string            `json:"EndTime" xml:"EndTime"`
	KvUsageData []KvUsageDataItem `json:"KvUsageData" xml:"KvUsageData"`
}

// CreateDescribeKvUsageDataRequest creates a request to invoke DescribeKvUsageData API
func CreateDescribeKvUsageDataRequest() (request *DescribeKvUsageDataRequest) {
	request = &DescribeKvUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeKvUsageData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeKvUsageDataResponse creates a response to parse from DescribeKvUsageData response
func CreateDescribeKvUsageDataResponse() (response *DescribeKvUsageDataResponse) {
	response = &DescribeKvUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
