package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafPolicy invokes the dcdn.DescribeDcdnWafPolicy API synchronously
func (client *Client) DescribeDcdnWafPolicy(request *DescribeDcdnWafPolicyRequest) (response *DescribeDcdnWafPolicyResponse, err error) {
	response = CreateDescribeDcdnWafPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafPolicyWithChan invokes the dcdn.DescribeDcdnWafPolicy API asynchronously
func (client *Client) DescribeDcdnWafPolicyWithChan(request *DescribeDcdnWafPolicyRequest) (<-chan *DescribeDcdnWafPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafPolicyWithCallback invokes the dcdn.DescribeDcdnWafPolicy API asynchronously
func (client *Client) DescribeDcdnWafPolicyWithCallback(request *DescribeDcdnWafPolicyRequest, callback func(response *DescribeDcdnWafPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafPolicyRequest is the request struct for api DescribeDcdnWafPolicy
type DescribeDcdnWafPolicyRequest struct {
	*requests.RpcRequest
	PolicyId requests.Integer `position:"Query" name:"PolicyId"`
}

// DescribeDcdnWafPolicyResponse is the response struct for api DescribeDcdnWafPolicy
type DescribeDcdnWafPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policy    Policy `json:"Policy" xml:"Policy"`
}

// CreateDescribeDcdnWafPolicyRequest creates a request to invoke DescribeDcdnWafPolicy API
func CreateDescribeDcdnWafPolicyRequest() (request *DescribeDcdnWafPolicyRequest) {
	request = &DescribeDcdnWafPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafPolicyResponse creates a response to parse from DescribeDcdnWafPolicy response
func CreateDescribeDcdnWafPolicyResponse() (response *DescribeDcdnWafPolicyResponse) {
	response = &DescribeDcdnWafPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
