package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafGroup invokes the dcdn.DescribeDcdnWafGroup API synchronously
func (client *Client) DescribeDcdnWafGroup(request *DescribeDcdnWafGroupRequest) (response *DescribeDcdnWafGroupResponse, err error) {
	response = CreateDescribeDcdnWafGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafGroupWithChan invokes the dcdn.DescribeDcdnWafGroup API asynchronously
func (client *Client) DescribeDcdnWafGroupWithChan(request *DescribeDcdnWafGroupRequest) (<-chan *DescribeDcdnWafGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafGroupWithCallback invokes the dcdn.DescribeDcdnWafGroup API asynchronously
func (client *Client) DescribeDcdnWafGroupWithCallback(request *DescribeDcdnWafGroupRequest, callback func(response *DescribeDcdnWafGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafGroupRequest is the request struct for api DescribeDcdnWafGroup
type DescribeDcdnWafGroupRequest struct {
	*requests.RpcRequest
	QueryArgs  string           `position:"Query" name:"QueryArgs"`
	Scope      string           `position:"Query" name:"Scope"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Language   string           `position:"Query" name:"Language"`
	Id         requests.Integer `position:"Query" name:"Id"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnWafGroupResponse is the response struct for api DescribeDcdnWafGroup
type DescribeDcdnWafGroupResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Id         int64      `json:"Id" xml:"Id"`
	Name       string     `json:"Name" xml:"Name"`
	TemplateId int64      `json:"TemplateId" xml:"TemplateId"`
	Subscribe  string     `json:"Subscribe" xml:"Subscribe"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	Rules      []RuleItem `json:"Rules" xml:"Rules"`
}

// CreateDescribeDcdnWafGroupRequest creates a request to invoke DescribeDcdnWafGroup API
func CreateDescribeDcdnWafGroupRequest() (request *DescribeDcdnWafGroupRequest) {
	request = &DescribeDcdnWafGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafGroupResponse creates a response to parse from DescribeDcdnWafGroup response
func CreateDescribeDcdnWafGroupResponse() (response *DescribeDcdnWafGroupResponse) {
	response = &DescribeDcdnWafGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
